/*//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Damage Handler
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// Handles damage events against entities, aims to try and fix bugs such as invicible enemies, by preventing them from being invicible.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Should try to fix the invisible entities?
const fixInvEntities = true;

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// The entity hurt event
EntityEvents.hurt(event => {
    // Constants
    const entity = event.getEntity();
    const isDeath = entity.getTags().contains("pa2_gotKilled");

	// Fixes the broken invincible entities
    if (fixInvEntities && !isDeath)
    {
        // In case of damage after health breaks (helps clear entities if they are broken already)
        if (isNaN(entity.getHealth()) || isNaN(entity.getAbsorptionAmount()))
        {
            entity.setHealth(0);
            entity.setAbsorptionAmount(0);

            entity.addTag("pa2_gotKilled");
            entity.kill();
            return;
        }

        // In case the damage is NaN and would cause the entity to break (sets damage to 1 to still trigger damage events)
        if (isNaN(event.getDamage()))
        {
            entity.attack(event.getSource(), 1);
            event.cancel();
            return;
        }
		
		// Check the result of the calculation between health and damage
		let result = entity.getHealth() - event.getDamage();
		if (isNaN(result))
		{
			event.cancel();
			return;
		}
    }
});

*/